#if defined(CLIP)
	varying vec3	v_clipVertex;
#endif
varying vec4	texCoords;
varying	vec3	Tangent;
varying	vec3	Binormal;
varying	vec3	Normal;
varying vec4	color;
uniform mat4	u_transformMatrix;
include colorGen_noFog.inc
include tcGen_multitexture_noFog.inc
include deforms.inc
void main(void)
{
	vec4 glVertex = DeformGeometry();
	tcGen(texCoords.xy, texCoords.zw, glVertex);
	Tangent = (u_transformMatrix * vec4(gl_MultiTexCoord2.xyz, 0.0)).xyz;
	Binormal = (u_transformMatrix * vec4(gl_MultiTexCoord3.xyz, 0.0)).xyz;
	Normal = (u_transformMatrix * vec4(gl_Normal, 0.0)).xyz;
	color = colorGen(glVertex);
	gl_Position = gl_ModelViewProjectionMatrix * glVertex;
	include clipVertex.inc
}
